/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef COMPARE_H
#define COMPARE_H
#include "types.h"
extern gint global_individual_count;
gboolean compare_a(individual *trainer, individual *myAudit);
gboolean compare_b(individual *trainer, individual *myAudit);
gint get_mag(GSList *auditList, individual *trainer, guint *mag_AandB,
	     guint *magA);
void get_fitness(GSList *auditList, individual *trainer, gdouble w1,
		 gdouble w2, guint N);
gint sort_function(gconstpointer a, gconstpointer b);
gint sort_functionV2(gconstpointer a, gconstpointer b);
void destroyInd(gpointer myInd);
gint get_crossByte(guint randInt);
void breed_v1(GRand *rnd, individual *parent1, individual *parent2, 
	   individual *child1, individual *child2 );
void breed_v2(GRand *rnd, individual *parent1, individual *parent2, 
	   individual *child1, individual *child2 );
void breed_midpoint(GRand *rnd, individual *parent1, individual *parent2,
		    individual *child1, individual *child2);
#endif




