/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <string.h>
#include <glib.h>
#include <glib/gprintf.h>
#include "types.h"
#include "print.h"
#include "read_bsm.h"
#include "service_attacks.h"

#include "compare.h"

#define WCARD_PROB 0.10

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif


int main() {
  GSList *auditList = NULL;
  time_stamp c;

  double w1 = 0.2;
  double w2 = 0.8;

  GArray *myArrayL[NUM_HTABLES];
  GArray *myArrayC[NUM_HTABLES][SUBH];

  individual *trainer; // Random Individual
  
  guint nRecords = 0;

  char *myfile = "./bsm.list";


  trainer = (individual *)g_slice_alloc0(sizeof(individual));

  c.tot = 0x00000000; // zero the IP address before loading values

  // not used field set to wildcard.
  c.byte[0] = 0xff; 
  // Duration
  // Hours
  c.byte[1] = 0x00; // -1 is the wildcard

  // Minutes
  c.byte[2] = 0x00; // -1 is the wildcard

  // Seconds
  c.byte[3] = 0xff; // -1 is the wildcard

  // Assign the Duration
  trainer->chrome[G_DURATION] = c.tot;

  // Assign the Protocol
  trainer->chrome[G_SERVICE] = -1;

  // Assign the Source Port
  trainer->chrome[G_SOURCE_PORT] = -1;  // Wildcard is 0xFFFFFFFF or -1

  // Assign the Destination Port
  trainer->chrome[G_DEST_PORT] = 0x17  ;

  // Source IP Address
  c.tot = 0x00000000; // zero the IP address before loading values

  // 1st Octet
  c.byte[0] = 0xc0; // -1 is the wildcard

  // 2nd Octet
  c.byte[1] = 0xa8; // -1 is the wildcard

  // 3rd Octet
  c.byte[2] = 0x01; // -1 is the wildcard

  // 4th Octet
  c.byte[3] = 0x1e; // -1 is the wildcard
  //  c.byte[3] = 0x1d; // -1 is the wildcard

  // Assign the Source IP
  trainer->chrome[G_SRC_IP] = c.tot;

  // Destination IP Address
  c.tot = 0x00000000; // zero the IP address before loading values

  // 1st Octet
  c.byte[0] = 0xc0; // -1 is the wildcard

  // 2nd Octet
  c.byte[1] = 0xff; // -1 is the wildcard

  // 3rd Octet
  c.byte[2] = 0x00; // -1 is the wildcard

  // 4th Octet
  c.byte[3] = 0x14; // -1 is the wildcard

  // Assign the Source IP
  trainer->chrome[G_DEST_IP] = c.tot;

  trainer->chrome[G_ATTACK] = GUESS_A;


  g_print("Test individual is the following\n");
  print_individual(trainer);
  g_print("Audit data pulled from %s\n",myfile);


  // Load the audit list
  nRecords = build_audit_array(&auditList, myArrayL, myArrayC, myfile);


  get_fitness(auditList, trainer, w1, w2, nRecords);


  g_print("Fitness from function\n");
  g_print("%.5f\n", trainer->fitness);


  return 0;

}
