/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>

gint compare2(gint a, gint b) {
  gint retVal;
  if (a < b) {
    retVal = -1;
  }
  else if ( a > b ) {
    retVal = 1;
  }
  else
    retVal = 0;
  return retVal;
}

gint compare(gint *a, gint *b, gpointer user_data)
{
  GArray *larray;
  gint intA, intB;
  gint retVal;

  larray = (GArray *)user_data;

  intA = g_array_index (larray, gint, *a);
  intB = g_array_index (larray, gint, *b);

  if (intA < intB) {
    retVal = -1;
  }
  else if ( intA > intB ) {
    retVal = 1;
  }
  else
    retVal = compare2(*a,*b);
  //g_printf("The test ran! a: %d b: %d\n",*a,*b);
  return retVal;
}

int main() {
  GArray *garray1, *garray2;
  gint i,j;
  GRand *rnd;

  g_mem_set_vtable(glib_mem_profiler_table);
  g_atexit(g_mem_profile);

  rnd = g_rand_new();


  /* We create a new array to store gint values.
     We don't want it zero-terminated or cleared to 0's. */
  garray1 = g_array_new (FALSE, FALSE, sizeof (gint));
  for (i = 2; i < 100 + 2; i++){
    //j = g_rand_int_range(rnd, 0, 350);
    j = i * i - 2 * i;
    g_array_append_val (garray1, j );
  }

 
  garray2 = g_array_new (FALSE, FALSE, sizeof (gint));
  for (i = 0; i < 100000; i++){
    j = i % 14;
    g_array_append_val (garray2, j );
  }

  g_array_sort_with_data(garray1, (GCompareDataFunc)compare, (gpointer)garray2);

  for (i = 0; i < 100; i++)
    //if (g_array_index (garray1, gint, i) != i)
      g_print (" got %d  %d\n",
               g_array_index (garray1, gint, i),
	       g_array_index (garray1, gint, i) % 14);
  g_array_free (garray1, TRUE);
  g_array_free (garray2, TRUE);
  g_rand_free(rnd);
  return 0;

}
