/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TYPES_H

#define TYPES_H

#define DESC_SZ 91

#define NUM_HTABLES 9 // number of main genes
#define SUBH 4 // number of sub-elements per chromosome

typedef struct
{
  char desc[DESC_SZ];
  int chrome[7]; // Attack is the last element
  double fitness;
} individual;

typedef union {
  char byte[4];
  unsigned int     tot;
} time_stamp;

typedef union {
  char octet[4];
  unsigned int full;
} IPAddr;

//enum attack{NEPTUNE=1,PASSWD_GUESS=2};
//enum protocol{FINGER=2,TELNET=3};



#endif
