/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include "types.h"
#include "print.h"   
#include "read_bsm.h"
#include "rand.h"

#include "service_attacks.h"

int main() {
  individual *parent1,*parent2;
  time_stamp c,d;
  //  gdouble myRandD;
  GRand *rnd;
  //gint i;
  guint nRecords = 0;
  char *myfile = "./bsm.list";

  GSList *auditList = NULL;
  GArray *myArrayL[NUM_HTABLES];
  GArray *myArrayC[NUM_HTABLES][SUBH];

  // Load the audit list
  nRecords = build_audit_array(&auditList, myArrayL, myArrayC, myfile);

  rnd = g_rand_new();

  parent1 = g_slice_new0(individual);
  parent2 = g_slice_new0(individual);

  c.tot = 0x00000000; // zero the IP address before loading values
  d.tot = 0x00000000;

  // Duration
  // first byte -1. Not used
  c.byte[0] = 0xff; // -1 is the wildcard
  d.byte[0] = 0xff;

  // Duration
  // Hours
  c.byte[1] = 1; // -1 is the wildcard
  d.byte[1] = 0x00;

  // Minutes
  c.byte[2] = 0xff; // -1 is the wildcard
  d.byte[2] = 0x02;

  // Seconds
  c.byte[3] = 0x28; // -1 is the wildcard
  d.byte[3] = 0x24;

  // Assign the Duration
  parent1->chrome[G_DURATION] = c.tot;
  parent2->chrome[G_DURATION] = d.tot;

  // Assign the Protocol
  parent1->chrome[G_SERVICE] = FTP;
  parent2->chrome[G_SERVICE] = RLOGIN;

  // Assign the Source Port
  parent1->chrome[G_SOURCE_PORT] = -1;  // Wildcard is 0xFFFFFFFF or -1
  parent2->chrome[G_SOURCE_PORT] = 44444; // Max port is 0x0000FFFF or 65,535   

  // Assign the Destination Port
  parent1->chrome[G_DEST_PORT] = 21  ;
  parent2->chrome[G_DEST_PORT]   = 25;

  // Source IP Address
  c.tot = 0x00000000; // zero the IP address before loading values
  d.tot = 0x00000000;

  // 1st Octet
  c.byte[0] = 0x09; // -1 is the wildcard
  d.byte[0] = 0x9E;

  // 2nd Octet
  c.byte[1] = 0x09; // -1 is the wildcard
  d.byte[1] = 0x22;

  // 3rd Octet
  c.byte[2] = 0x09; // -1 is the wildcard
  d.byte[2] = 0x02;

  // 4th Octet
  c.byte[3] = 0xFF; // -1 is the wildcard
  d.byte[3] = 0x14;



  // Assign the Source IP
  parent1->chrome[G_SRC_IP] = c.tot;
  parent2->chrome[G_SRC_IP] = d.tot;

  // Destination IP Address
  c.tot = 0x00000000; // zero the temp variable
  d.tot = 0x00000000; // zero the temp variable

  // 1st Octet
  c.byte[0] = 0xc0; // 192
  d.byte[0] = 0x87;

  // 2nd Octet
  c.byte[1] = 0xA8; // 168
  d.byte[1] = 0x23;

  // 3rd Octet
  c.byte[2] = 0x01; // 1 
  d.byte[2] = 0x22; // -1 is the wildcard

  // 4th Octet
  c.byte[3] = 0x0D; // 12
  d.byte[3] = 0xee; // -1

  // Assign the Destination IP
  parent1->chrome[G_DEST_IP] = c.tot;
  parent2->chrome[G_DEST_IP] = d.tot;

  parent1->chrome[G_ATTACK] = PORT_SCAN_A;
  parent2->chrome[G_ATTACK] = RCP_A;

  //g_print("Parent1\n");
  //print_individual(parent1);
  mutateInd(0.10, 0.10, parent1, 
	    myArrayL, myArrayC);
  //g_print("Parent1 after mutate\n");
  print_individual(parent1);
  
  return 0;
}
