#!/usr/bin/perl

# Configuration Variables
# Change these variables to match your web server's configuration

use strict;
use File::Find;

my $base_dir = "/home/brian/public_html/bbd/";

finddepth(\&wanted, $base_dir);


sub wanted { 

  if (/\.html$/) {

    my $file = "$File::Find::name";
    my $old = "$file";
    my $new = "$file.tmp.$$";
    my $bak = "$file.bak";

    open(OLD, "< $old")         or die "can't open $old: $!";
    open(NEW, "> $new")         or die "can't open $new: $!";


    # replace old banner with new one
    while (<OLD>) {
      if (/<!-- replace navigable bar begin -->/) {
	while (! $_ =~ /<!-- replace navigable bar end -->/) {
	  <OLD>;
	}
        print NEW '<!-- replace navigable bar begin -->',"\n";
        print NEW '<IMG SRC="/brian/pictures/bar.gif" WIDTH=551 HEIGHT=28 BORDER=2 >',"\n";
        print NEW '<!-- replace navigable bar end -->',"\n";
      } else {
	(print NEW $_)          or die "can't write to $new: $!";
      }
    }

    close(OLD)                  or die "can't close $old: $!";
    close(NEW)                  or die "can't close $new: $!";

    rename($old, $bak)          or die "can't rename $old to $bak: $!";
    rename($new, $old)          or die "can't rename $new to $old: $!";

  }

}


