#!/usr/bin/perl

# Configuration Variables
# Change these variables to match your web server's configuration

use File::Find;
use strict;


my $base_url = "http://www.brie.com";
my $base_dir = "/home/www/htdocs";
my $i = 1;


if (! -f "$base_dir/site.html") {
  open (OUTFILE , ">$base_dir/site.html");
} else {
  die "$base_dir/site.html already exists.\n Remove or move it before running this\n";
}

print OUTFILE << "__END__";
<html>
<head>
<title>Site Mapa</title>
<body>
<h1>$base_url Site Map</h1>
<PRE>
__END__

finddepth(\&wanted, $base_dir);

print OUTFILE << "__END__";
</PRE>
<P>
Originally developed by: <br>
<address>
<a href="mailto:brian\@brie.com">Brian Lavender</a>
</address>
</html>
__END__

sub wanted { 

  if (/\.html$/) {
    my $temp = $File::Find::name;
    $temp =~ s/\Q$base_dir//;
    printf OUTFILE ("%5d",$i);
    print OUTFILE qq{  <A HREF="},$base_url,$temp, qq{">},$temp,"</A>\n"; 
    if ($i % 5 == 0) { print OUTFILE "\n"};
    $i++;
  }

}


